/*
 * @(#)ZipMenuFichier.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.AbstractButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


import java.io.File;



/**
 * Class used to create the file menu
 * @see AllActionListener
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMenuFichier extends JMenu {
    

    /**
     * Class constructor
     * @param allActionListener
     */
    public ZipMenuFichier(AllActionListener allActionListener) {
	super("File");

	// create menu items
	JMenuItem NewItem = new JMenuItem("New");
	JMenuItem OpenItem = new JMenuItem("Open");
	JMenuItem QuitItem = new JMenuItem("Quit");

	// setup the menu items
	NewItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	OpenItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	QuitItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	NewItem.setActionCommand("New");
	OpenItem.setActionCommand("Open");
	QuitItem.setActionCommand("Quit");
	NewItem.addActionListener(allActionListener);
	OpenItem.addActionListener(allActionListener);
	QuitItem.addActionListener(allActionListener);

	// add the menu items
	add(NewItem);
	add(OpenItem);
	addSeparator();
	add(QuitItem);

    }
}
